/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client;

import com.ibm.hsc.cim.client.HSCCltObjCache;
import com.ibm.hsc.client.HSCClient;
import com.ibm.hsc.client.HSCOutputStrHandler;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.HscUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;

public class HSCCIMClient
implements HSCClient,
HSCOutputStrHandler {
    protected CIMInstance mInst = null;
    protected CIMObjectPath mObjectPath = null;
    protected HSCCIMClient mParentObject = null;
    protected String mIntName;
    protected String mHostName;
    protected String mUserDefinedName;
    protected static final int DLPAR_ENABLED = 15;
    protected static final int HMC_CSP_DISCONNECTED_TMP = 2;
    protected static final String CREATION_CLASS_NAME = "CreationClassName";
    protected static final String CONFIGURATION = "Configuration";
    protected static final String ELEMENT = "Element";
    protected static final String GROUP_COMPONENT = "GroupComponent";
    protected static final String PART_COMPONENT = "PartComponent";
    protected static final String NAME = "name";
    protected static final String SETTING = "Setting";
    protected static final String MOF_NAME = "Name";
    protected static final String MOF_USER_DEFINED_NAME = "UserDefinedName";
    protected static final String MOF_SETTING_ID = "SettingID";
    protected static final String MOF_FRAME_NUM = "FrameNumber";
    protected static final String MOF_IO_DRAWER = "IODrawer";
    protected static final String MOF_IO_SLOTS = "IOSlots";
    protected static final String MOF_IO_REQUIREMENT = "IORequirement";
    protected static final String MOF_DLPAR_CAPABILITIES = "DLPARCapabilities";
    protected HSCOutputStrHandler mOutputStrHandler = null;

    public static HSCCIMClient createInstance(String string) {
        return new HSCCIMClient(string, null, null, null);
    }

    public HSCCIMClient(String string, HSCCIMClient hSCCIMClient, String string2, CIMObjectPath cIMObjectPath) {
        this.mParentObject = hSCCIMClient;
        this.mIntName = string2;
        this.mHostName = string;
        this.mObjectPath = cIMObjectPath;
        this.mOutputStrHandler = this;
    }

    public void setOutputStrHandler(HSCOutputStrHandler hSCOutputStrHandler) {
        this.mOutputStrHandler = hSCOutputStrHandler;
    }

    public void handleOutputStr(String string) {
    }

    public CIMObjectPath getObjectPath() {
        return this.mObjectPath;
    }

    public String getIntName() {
        return this.mIntName;
    }

    public String getUserDefinedName() {
        return this.mUserDefinedName;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public HSCClient getParentObject() {
        return this.mParentObject;
    }

    public CIMInstance getCIMInstance() throws HSCException {
        if (this.mInst != null) {
            return this.mInst;
        }
        try {
            this.mInst = HscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            return this.mInst;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new HSCException(exception);
        }
    }

    public void disableSurveillance() throws HSCException {
        CIMInstance cIMInstance = null;
        Enumeration enumeration = null;
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
        try {
            enumeration = HscUtil.getCIMEnumInstances(this.mHostName, cIMObjectPath, true);
            while (enumeration != null && enumeration.hasMoreElements()) {
                cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                cIMInstance = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath, false);
                if (((UnsignedInt16)cIMInstance.getProperty("CspSurveillancePolicy").getValue().getValue()).intValue() <= 0) continue;
                cIMInstance.setProperty("CspSurveillancePolicy", new CIMValue((Object)new UnsignedInt16(2)));
                HscUtil.setCIMInstance(this.mHostName, cIMObjectPath, cIMInstance);
            }
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
    }

    public static Hashtable getFrameList(String string) {
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Object> hashtable2 = null;
        String string2 = null;
        HSCCltObjCache hSCCltObjCache = HSCCltObjCache.getInstance();
        hSCCltObjCache.cleanup();
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
            Enumeration enumeration = HscUtil.getCIMEnumInstances(string, cIMObjectPath, true);
            while (enumeration.hasMoreElements()) {
                Boolean bl;
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                CIMInstance cIMInstance = HscUtil.getCIMInstance(string, cIMObjectPath2, true);
                CIMValue cIMValue = cIMInstance.getProperty(MOF_NAME).getValue();
                hashtable2 = new Hashtable<String, Object>();
                if (cIMValue == null) continue;
                string2 = (String)cIMValue.getValue();
                hashtable2.put(NAME, string2);
                cIMValue = cIMInstance.getProperty("isFrame").getValue();
                if (cIMValue != null) {
                    bl = (Boolean)cIMValue.getValue();
                    if (bl != null && bl.booleanValue()) {
                        hashtable2.put("isFrame_PROP", bl);
                    } else {
                        hashtable2.put("isFrame_PROP", new Boolean(false));
                    }
                } else {
                    hashtable2.put("isFrame_PROP", new Boolean(false));
                }
                cIMValue = cIMInstance.getProperty(MOF_FRAME_NUM).getValue();
                if (cIMValue != null) {
                    bl = (UnsignedInt16)cIMValue.getValue();
                    if (bl != null && bl.intValue() != 0) {
                        hashtable2.put("frameNumber_PROP", new String(bl.toString()));
                    } else {
                        hashtable2.put("frameNumber_PROP", "");
                    }
                } else {
                    hashtable2.put("frameNumber_PROP", "");
                }
                hashtable.put(string2, hashtable2);
            }
            return hashtable;
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            return null;
        }
    }
}

